{{ ucfunc("put_docready_start") }}

  const cardWrappers = document.querySelectorAll('.ue-glowing-card-wrapper');

  let cardCounter = 0;

  cardWrappers.forEach(cardWrapper => {
    
    const wrapperId = {{uc_id}} + '_wrapper_' + (cardCounter++);
    
    cardWrapper.setAttribute('id', wrapperId);
    
    const cursorGlow = cardWrapper.querySelector('.ue-glowing-cursor-glow');
    const borderGlow = cardWrapper.querySelector('.ue-glowing-border-glow');
    
    if (cursorGlow) {
      cursorGlow.setAttribute('id', wrapperId + '_cursor');
    }
    
    if (borderGlow) {
      borderGlow.setAttribute('id', wrapperId + '_border');
    }
    
    
    cardWrapper.addEventListener('mousemove', (e) => {
      // Get position relative to wrapper
      const rect = cardWrapper.getBoundingClientRect();
      const x = e.clientX - rect.left;
      const y = e.clientY - rect.top;
      
      // Position the cursor glow
      cursorGlow.style.opacity = '1';
      cursorGlow.style.left = x + 'px';
      cursorGlow.style.top = y + 'px';
      
      // Check if cursor is near the border
      const borderThreshold = 100; // Pixels from edge
      
      // Calculate distance to each edge
      const distToTop = y;
      const distToRight = rect.width - x;
      const distToBottom = rect.height - y;
      const distToLeft = x;
      
      const minDist = Math.min(distToTop, distToRight, distToBottom, distToLeft);
      
      // Only show border glow when near the edge
      if (minDist < borderThreshold) {
        borderGlow.style.opacity = '1';
        
        // Calculate position on the border
        let borderX = x;
        let borderY = y;
        
        // Clamp to the exact border position
        if (minDist === distToTop) {
          borderY = 0;
        } else if (minDist === distToRight) {
          borderX = rect.width;
        } else if (minDist === distToBottom) {
          borderY = rect.height;
        } else if (minDist === distToLeft) {
          borderX = 0;
        }
        
        // Position the border glow
        borderGlow.style.left = borderX + 'px';
        borderGlow.style.top = borderY + 'px';
      } else {
        borderGlow.style.opacity = '0';
      }
    });
    
    cardWrapper.addEventListener('mouseleave', () => {
      // Hide both glows
      cursorGlow.style.opacity = '0';
      borderGlow.style.opacity = '0';
    });
  });

{{ ucfunc("put_docready_end") }}