jQuery(document).ready(function() {
    function {{uc_id}}_start() {
        var objCarousel = jQuery('#{{uc_id}} .owl-carousel');
        
        if (!objCarousel.length) return;

        var carouselOptions = {
            loop: {{loop}},
            nav: false,
            rtl: {{rtl}},
            dots: {{show_dots}},
            center: {{ue_center}},
            autoplay: {{autoplay}},
            autoplayTimeout: {{autoplay_timeout}},
            autoplayHoverPause: {{autoplay_hover_pause}},
            smartSpeed: {{transition_speed}},
            margin: 0,
            changeItemOnClick: {{change_item_on_click}},  
            responsive: {
                0: {
                    items: {{number_of_items_mobile}}
                    {% if stage_padding_type != 'none' %},
                    stagePadding: {{stage_padding_mobile}}
                    {% endif %}
                },
                768: {
                    items: {{number_of_items_tablet}}
                    {% if stage_padding_type != 'none' %},
                    stagePadding: {{stage_padding_tablet}}
                    {% endif %}
                },
                980: {
                    items: {{number_of_items}}
                    {% if stage_padding_type != 'none' %},
                    stagePadding: {{stage_padding}}
                    {% endif %}
                }
            }
        };

        // Initialize carousel
        objCarousel.owlCarousel(carouselOptions);

        // Navigation event handlers
        jQuery('#{{uc_id}} .carousel-next').on('click', function() {
            objCarousel.trigger('next.owl.carousel');
        });

        jQuery('#{{uc_id}} .carousel-prev').on('click', function() {
            objCarousel.trigger('prev.owl.carousel');
        });

        // Ajax content handling
        objCarousel.on("uc_ajax_sethtml", function(event, htmlItems, isAppend) {
            objCarousel.one("uc_ajax_refreshed", function() {
                objCarousel.trigger('destroy.owl.carousel');
                {{uc_id}}_start();
            });
            
            objCarousel.trigger("replace.owl.carousel", htmlItems);
            objCarousel.trigger("refresh.owl.carousel");
        });

        {{ucfunc("put_remote_parent_js","objCarousel")}}
    }

    // Initialization with delay and popup support
    setTimeout(function() {
        if (jQuery("#{{uc_id}}").length) {
            {{uc_id}}_start();
        } else {
            jQuery(document).on('elementor/popup/show', function() {
                if (jQuery("#{{uc_id}}").length) {
                    {{uc_id}}_start();
                }
            });
        }
    }, 100);
});