{# twig vars #}{##}
{% set date = item.date_stamp|ucdate(date_format)|raw %} 
{% if item.post.date is not empty %}
  {% set date =  item.post.date|ucdate(date_format)|raw %} 
{% endif %}

{% set dateElem %}
<div class="ue-item-date">{% if item.date_type == "picker" %}{{ date }}{% else %}{{item.date_text|raw}}{% endif %}</div>      	
{% if show_time_ago == "true" and item.date_type == "picker" %}<div class="ue-grid-item-meta-data"><span class="ue-grid-item-meta-data-icon">{{time_ago_icon_html|raw}}</span> {{text_before_time_ago|raw}} {{item.date_stamp|ucdate("time_ago")|raw}}</div>{% endif %}
{% endset %}
{# end twig vars #}{##}

<div class="ue-carousel-item {{item.item_repeater_class}}">
  {% if show_date == "before" %}{{dateElem}}{% endif %}
  <div class="ue-item-bullet-holder">
    <div class="ue-item-bullet-line"></div>
    <div class="ue-item-bullet-line-spacing"></div>
    <div class="ue-item-bullet">
      {% if bullet_type == "icon" %}{% if item.icon is not empty  %}{{ item.icon_html|raw }}{% else %}{{icon_html|raw}}{% endif %}{% endif %}
      {% if bullet_type == "index" %}{{ item.item_index }}{% endif %}
    </div>
    <div class="ue-item-bullet-line-spacing"></div>
    <div class="ue-item-bullet-line"></div>
  </div>

  {% if show_date == "after" %}{{dateElem}}{% endif %} 

  {% if show_vertical_line == "true" %}
  <div class="ue-item-vertical-line-holder">
    <div class="ue-item-vertical-line"></div>
  </div>
  {% endif %}
  
  {% if show_pointer == "true" %}
  <div class="ue-item-pointer-holder">
    <div class="ue-item-pointer"></div>
  </div>
  {% endif %}
  
   <div class="ue-carousel-item-holder">
    {% if item.image is not empty %}
      <div class="ue-item-image">
        <a href="{{ item.link }}" {{ item.link_html_attributes|raw }}>
          <img src="{{ item.image }}" alt="{{ item.title }}">
        </a>
      </div>
    {% endif %}

    {% if show_content == "true" %}
      <div class="ue-carousel-content">
        <div class="ue-carousel-content-inside">
          {% if show_label == "true" %}
            <div class="ue-item-label">{{ item.label }}</div>
          {% endif %}
          <div class="ue-item-title">
            <a {% if disable_link_in_title == "false" %}href="{{ item.link }}"{% endif %} {{ item.link_html_attributes|raw }}>{{ item.title|raw }}</a>
          </div>
          {% if show_intro == "true" %}
          <div class="ue-item-intro">{{item.description|truncate(intro_number_of_characters)|raw}}</div>
            {% endif %}
        </div>

        {% if show_button == "true" %}
          <div class="ue-btn-holder">
            <a class="ue-btn {{ button_hover_effect }}" href="{{ item.link }}" {{ item.link_html_attributes|raw }}>{% if item.button_text|raw is not empty %}{{item.button_text|raw}} {% else %}  {{ read_txt|raw }} {% endif %}</a>
          </div>
        {% endif %}
      </div>
    {% endif %}
  </div>
</div>