{% set addClass = "" %}
{% set contentStyle = "" %}

{% if (first_accordion_closed == "false" and item.item_index == 1) %}
	{% set addClass = "uc-item-active" %}
	{% set contentStyle = "style='display:block'" %}
{% endif %}

<div id="{{item.item_id}}" class="uc_ac_box {{addClass}} {{item.item_repeater_class}}">
  <div class="uc-heading uc_trigger" role="button" aria-controls="{{item.item_id}}-content" tabindex="0" aria-expanded="{% if (first_accordion_closed == "false" and item.item_index == 1) %}true{% else %}false{% endif %}">
    
    {% if show_icon == "true" %}
      <div class="ue_icon_holder">
        <div class="ue_icon">{{item.icon_html|raw}}</div>
      </div>
      <div class="ue_icon_spacing"></div>
    {% endif %}
    
    <{{title_html_tag}} id="{{item.item_id}}-title" class="ue_title">{{item.title|raw}}</{{title_html_tag}}>    
    
    {% if show_expand == "true" %}
      <div class="ue_expand_spacing"></div>
      <div class="ue_expand">
        <div class="ue_expand_inside">
          <span class="uc_dactive bbb ue_accordion_icon" >{{expand_icon_html|raw}}</span>
          <span class="uc_active bbb ue_accordion_icon">{{collapse_icon_html|raw}}</span>
        </div>
      </div>
    {% endif %}
    
  </div>
  
  <div id="{{item.item_id}}-content" class="uc_content" role="region" aria-labelledby="{{item.item_id}}-title" {{contentStyle|raw}}>
    {% if item.content_type == "content" %}
      {{item.content|raw}}
    {% endif %} 
    
    {% if item.content_type == "template" %}
      {{putElementorTemplate(item.load_template_templateid)}}
    {% endif %} 
    
  </div>
</div>