#{{uc_id}} {
	width: 100%;
	margin: 0 auto;
	--card-top-offset: {{card_top_offset}};
    --card-height:{{card_height}};
}

@media (max-width: 1024px) {
  #{{uc_id}} {
	--card-top-offset: {{card_top_offset_tablet}} {% if card_top_offset_tablet is empty %}{{card_top_offset}}{% endif %};
    --card-height:{{card_height_tablet}}{% if card_height_tablet is empty %}{{card_height}}{% endif %};
  }
}
@media (max-width: 767px) {
  #{{uc_id}} {
	--card-top-offset: {{card_top_offset_mobile}} {% if card_top_offset_mobile is empty %}{{card_top_offset}}{% endif %};
    --card-height:{{card_height_mobile}} {% if card_height_mobile is empty %}{{card_height}}{% endif %};
  }
}

#{{uc_id}} .ue_cards_wrapper {
    padding-bottom: calc({{uc_num_items}} * var(--card-top-offset)); /* Make place at bottom, as items will slide to that position*/
  	display: grid;
    justify-items: center;
	grid-template-columns: 1fr;
    grid-template-rows: repeat({{uc_num_items}}, var(--card-height));
    /* margin-bottom: var(--card-margin);
	gap: var(--card-margin); */
}

#{{uc_id}} .ue_stacking_card_item {
	/*position: sticky;*//* will be nabled in js to allow calc of start position of the cards */
    padding-top: var(--card-top-offset);
	transform-origin: {{transform_origin_x}} {{transform_origin_y}};
	will-change: transform;
}

#{{uc_id}} .ue_card_content {
    height: var(--card-height);
    min-height: var(--card-height);
	overflow: hidden;
	display: flex;
	align-items: stretch;
}

{% if image_position == "row" and alternate_image == "true" %}
  #{{uc_id}} .ue_stacking_card_item:nth-child(even) .ue_card_content{
    flex-direction: row-reverse;
  }
{% endif %}
{% if image_position == "row-reverse" and alternate_image == "true" %}
  #{{uc_id}} .ue_stacking_card_item:nth-child(even) .ue_card_content{
    flex-direction: row;
  }
{% endif %}

#{{uc_id}} .ue_content_left {
	/*place-self: center;*/
	/*display: grid;*/
    display: flex;
    flex-direction: column;
    flex-shrink: 0;
    {% if (image_position == "column" or image_position == "column-reverse") and (content_height is empty) %}height:auto;{% endif %}
}

#{{uc_id}} .ue_card_content > figure {
	overflow: hidden;
    flex-grow: 1;
}

#{{uc_id}} .ue_card_content > figure .ue_sc_img,
#{{uc_id}} .ue_card_content > figure > a{
	width: 100%;
	height: 100%;
}

#{{uc_id}} .ue_sc_button {
	display: inline-block;
    height: fit-content;
    overflow:hidden;
}

{% if show_graphic_element != "no" %}
 #{{uc_id}} .ue_sc_graphic_el{
   display:flex;
   justify-content:center;
   align-content:center;
   align-items:center;
   overflow:hidden;
   flex-shrink: 0;
 }
 #{{uc_id}} .ue_sc_graphic_el svg{
  width:1em;
  height:1em;
 }
{% endif %}

{% if scroll_related_animation == "true" %}
 #{{uc_id}} .ue_stacking_card_item{
  transform: translate3d(0px, 0px, 0px) rotate({{rotation}}deg);
  filter: blur(0px) grayscale({{greyscale}});
 }
{% endif %}

/* soft styles*/
.ue_sc_title {
	font-weight: 300;
	font-size: 2.4em;
    line-height: 1.2;
}

.ue_sc_desc {
	font-weight: 300;
	line-height: 1.42;
}
.ue_stacking_card_item {
  width:100%;
}
.ue_card_content {
	box-shadow: 0px 10px 40px 0px rgba(0, 0, 0, 0.30);
}
/* */

/* start creative button hover styles */
#{{uc_id}} .uc_content{
  display: flex;
  flex-wrap: wrap;
}

/* GENERAL BUTTON STYLING */
#{{uc_id}} .uc_button {
  overflow:hidden;
  flex-shrink: 0;
}

#{{uc_id}} .uc_button,
#{{uc_id}} .uc_button::after {
	transition: all 0.3s;
}

#{{uc_id}} .uc_button {
  position: relative;
}

#{{uc_id}} .uc_button span{
  z-index: 2;
  position: relative;
  display: block;
}

#{{uc_id}} .uc_button::before,
#{{uc_id}} .uc_button::after {
  content: '';
  position: absolute;
  z-index: 1;
}

/* BUTTON 1 */
#{{uc_id}} .uc_btn-1::after {
  height: 0;
  left: 0;
  top: 0;
  width: 100%;
}

#{{uc_id}} .uc_btn-1:hover:after {
  height: 100%;
}

/* BUTTON 7 */
#{{uc_id}} .uc_btn-7::after {
  height: 0;
  left: 0;
  bottom: 0;
  width: 100%;
}

#{{uc_id}} .uc_btn-7:hover:after {
  height: 100%;
}

/* BUTTON 2 */
#{{uc_id}} .uc_btn-2::after {
  height: 100%;
  left: 0;
  top: 0;
  width: 0;
}

#{{uc_id}} .uc_btn-2:hover:after {
  width: 100%;
}

/* BUTTON 6 */
#{{uc_id}} .uc_btn-6::after {
  height: 100%;
  right: 0;
  top: 0;
  width: 0;
}

#{{uc_id}} .uc_btn-6:hover:after {
  width: 100%;
}

/* BUTTON 3 */
#{{uc_id}} .uc_btn-3::after {
  height: 0;
  left: 50%;
  top: 50%;
  width: 0;
}

#{{uc_id}} .uc_btn-3:hover:after {
  height: 100%;
  left: 0;
  top: 0;
  width: 100%;
}


/* BUTTON 4 */
#{{uc_id}} .uc_btn-4::before {
}

#{{uc_id}} .uc_btn-4::after {
  height: 100%;
  left: 0;
  top: 0;
  width: 100%;
}

#{{uc_id}} .uc_btn-4:hover:after{
  height: 0;
  left: 50%;
  top: 50%;
  width: 0;
}


/* BUTTON 5 */
#{{uc_id}} .uc_btn-5 {
  overflow: hidden;
}

#{{uc_id}} .uc_btn-5::after {
  height: 100%;
  left: -100%;
  top: 0;
  transform: skew(50deg);
  transition-duration: 0.6s;
  transform-origin: top left;
  width: 0;
}

#{{uc_id}} .uc_btn-5:hover:after {
  height: 100%;
  width: 200%;
}
/* end styles */
#{{uc_id}} .ue_content_wrapper {
  display: flex;
  align-items: stretch;
  position:relative;
  height:100%;
  width: 100%;
}
{% if disable_section_id_source_js != "true" %}
#{{uc_id}} .ue_stacking_card_item.uc-item-error .ue_content_wrapper,
#{{uc_id}} .ue_stacking_card_item.uc-item-message .ue_content_wrapper{
  justify-content: center;
  align-items: center;
}
#{{uc_id}} .uc-error{
  color:red;
  font-weight:500;
}
#{{uc_id}} .uc-message{
  font-weight:500;
}
{% endif %}