{# twig vars #}{##}
{% set iconsElem %}
<div class="team_member_carousel_icons">
  {% if item.icon_one is empty %}{% else %}<a class="{{icon_hover_effect}}" href="{{item.link_one}}" {{item.link_one_html_attributes|raw}}>{{item.icon_one_html|raw}}</a>{% endif %}	
  {% if item.icon_two is empty %}{% else %}<a class="{{icon_hover_effect}}" href="{{item.link_two}}" {{item.link_two_html_attributes|raw}}>{{item.icon_two_html|raw}}</a>{% endif %}	
  {% if item.icon_three is empty %}{% else %}<a class="{{icon_hover_effect}}" href="{{item.link_three}}" {{item.link_three_html_attributes|raw}}>{{item.icon_three_html|raw}}</a>{% endif %}	
  {% if item.icon_four is empty %}{% else %}<a class="{{icon_hover_effect}}" href="{{item.link_four}}" {{item.link_four_html_attributes|raw}}>{{item.icon_four_html|raw}}</a>{% endif %}	
</div>
{% endset %}{# end iconsElem #}{##}

{% set logoElem %}<div class="ue-company-logo"><img src="{{item.company_logo}}"></div>{% endset %}

{% set subTitleElem %}<div class="team_member_carousel_subtitle">{{item.subtitle|raw}}</div>{% endset %}

{% set titleElem %}<div class="team_member_carousel_title">{{item.title|raw}}</div>{% endset %}

{% set buttonElem %}
<div class="team_member_carousel_button">
  {% if multisource != "uc_items" %}
    <a class="uc_more_btn ue-dynamic-popup-single {{item.dynamic_popup_link_class}}" {{item.dynamic_popup_link_attributes|raw}}>{% if item.button_text is not empty %}{{item.button_text|raw}}{% else %}{{button_text}}{%  endif %}</a>
  {% else %}
    <a class="uc_more_btn" href="{{item.button_link}}" {{item.button_link_html_attributes|raw}}>{% if item.button_text is not empty %}{{item.button_text|raw}}{% else %}{{button_text}}{%  endif %}</a>
  {% endif %}
</div>
{% endset %}{# end buttonElem #}{##}
{# end twig vars #}{##}

<div class="ue_carousel_item ue-item ue-carousel-item">
  {% if show_text_header == "true" %}<div class="ue-text-header">{{item.text_header|raw}}</div>{% endif %}
  
  {% if show_image == "true" %}
  <div class="team_member_carousel_image">
    <div class="team_member_carousel_image_container">       
       <a class="team_member_carousel_image-link" {% if item.image_link is not empty %}href="{{item.image_link}}" {{item.image_link_html_attributes|raw}}{% endif %}>
         <img src="{{item.image}}" alt="{{item.image_alt}}" {{item.image_attributes|raw}}>
      	 <div class="team_member_carousel_image_overlay">         
          {% if show_title == "overlay" %}{{titleElem}}{% endif %}	
          {% if show_subtitle == "overlay" %}{{subTitleElem}}{% endif %}	
          {% if show_button == "overlay" %}{{buttonElem}}{% endif %}
          {% if show_icons == "overlay" %}{{iconsElem}}{% endif %}
        </div> 
      </a>         
    </div>
  </div>
  {% endif %}
  
  <div class="team_member_carousel_content">
    {% if show_title == "content" %}{{titleElem}}{% endif %}	
    {% if show_subtitle == "content" %}{{subTitleElem}}{% endif %}	
    {% if company_logo == "before" %}{{logoElem}}{% endif %}
    {% if show_icons == "content" and icons_placement == "before" %}{{iconsElem}}{% endif %}
    {% if show_text == "true" %}<div class="team_member_carousel_text">{{item.text|raw}}</div>{% endif %}
    {% if company_logo == "after" %}{{logoElem}}{% endif %}	
    {% if item.additional_image == "true" %}<div class="ue-additional-image"><img src="{{item.additional_image_img}}"></div>{% endif %}	
    {% if show_icons == "content" and icons_placement == "after" %}{{iconsElem}}{% endif %}
    {% if show_button == "content" %}{{buttonElem}}{% endif %}
  </div>
  
</div>