#{{uc_id}} .ue_glare_button{
  display:inline-flex;
  align-items: center;
  cursor: pointer;
  border-radius: {{border_radius}}px;
  overflow: hidden;
  position: relative;
  text-decoration:none;
}

#{{uc_id}} .ue_glare_button div {
  display: block;
  position: relative;
  z-index: 10;
}

#{{uc_id}} .ue_glare_button:after,
#{{uc_id}} .ue_glare_button:before {
  content: '';
  position: absolute;
  top: 0;
  left: calc(-100% - 30px);
  height: calc(100%);
  width: calc(100% + 20px);
  transform: skew(-25deg);
}

#{{uc_id}} .ue_glare_button:after {
  transition: left {{glare_transition_duration * 0.8}}ms cubic-bezier(0.86, 0, 0.07, 1) 0.2s;
  z-index: 0;
}

#{{uc_id}} .ue_glare_button:before {
  z-index: 5;
  transition: left {{glare_transition_duration}}ms cubic-bezier(0.86, 0, 0.07, 1);
}

#{{uc_id}} .ue_glare_button:hover:after {
  left: calc(0% - 10px);
  transition: left {{glare_transition_duration * 0.8}}ms cubic-bezier(0.86, 0, 0.07, 1);
}

#{{uc_id}} .ue_glare_button:hover:before {
  left: calc(0% - 10px);
  transition: left {{glare_transition_duration}}ms cubic-bezier(0.86, 0, 0.07, 1);
}

{% if show_icon == "true" %}
  #{{uc_id}} .ue_btn_icon{
    display:flex;
    justify-content:center;
    align-items:center;
    z-index: 10;
  }
  #{{uc_id}} .ue_btn_icon svg{
    width:1em;
    height:1em;
  }
{% endif %}